package hbase;


import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class HBaseTemperatureImporterV1 extends Configured implements Tool {
	private static final byte[] FAMILY = Bytes.toBytes("data");
	private static final byte[] YEAR = Bytes.toBytes("year");
	private static final byte[] TEMPERATURE = Bytes.toBytes("temperature");
	
	public int run(String[] args) throws IOException {
		if (args.length != 1) {
			System.err.println("Usage: HBaseTemperatureImporterV1 <input_directory>");
			return -1;
		}
		
		NcdcRecordParser parser = new NcdcRecordParser();
		HTable table = new HTable(HBaseConfiguration.create(getConf()), "records");
		for (File file : new File(args[0]).listFiles()) {
			BufferedReader reader = new BufferedReader(new InputStreamReader(
					new GZIPInputStream(new FileInputStream(file))));
			for (String line=reader.readLine(); line!=null; line=reader.readLine()) {
				
				parser.parse(line.toString());
				if (parser.isValidTemperature()) {
					byte[] rowKey = RowKeyConverter.makeObservationRowKey(
							parser.getStationId(),
							parser.getObservationDate().getTime());
					Put p = new Put(rowKey);
					p.add(FAMILY, YEAR, Bytes.toBytes(parser.getYear()));
					p.add(FAMILY, TEMPERATURE, Bytes.toBytes(parser.getAirTemperature()));
					table.put(p);
				}

			}
			reader.close();
		}
		table.close();
		return 0;
	}

	public static void main(String[] args) throws Exception {
		int exitCode = ToolRunner.run(HBaseConfiguration.create(), new HBaseTemperatureImporterV1(), args);
		System.exit(exitCode);
	}
}
