package hbase;

import java.io.IOException;

import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ListStations extends Configured implements Tool {
	private static final byte[] FAMILY = Bytes.toBytes("data");
	private static final byte[] STATION_ID = Bytes.toBytes("id");

	public int run(String[] args) throws IOException {
		if (args.length != 1) {
			System.err.println("Usage: ListStations <city_name>");
			return -1;
		}
		String name = args[0];

		HTable table = new HTable(HBaseConfiguration.create(getConf()), "stations");
		Scan scan = new Scan();
		scan.addFamily(FAMILY);
		ResultScanner scanner = table.getScanner(scan);
		try {
			for (Result scannerResult : scanner) {
				byte[] stationName = scannerResult.getRow();
				if (Bytes.toString(stationName).startsWith(name)) {
					byte[] stationId = scannerResult.getValue(FAMILY, STATION_ID);
					if (stationId != null) {
						System.out.printf("%s\t%s\n", Bytes.toString(stationName), Bytes.toString(stationId));
					}
				}
			}
		} finally {
			scanner.close();
			table.close();
		}
		return 0;
	}
	
	public static void main(String[] args) throws Exception {
		int exitCode = ToolRunner.run(HBaseConfiguration.create(), new ListStations(), args);
		System.exit(exitCode);
	}
}