#include "cbuffer.h"

cbuffer my_object;
static unsigned int next_id = 0;
extern "C" {
/* you must have the following symbols */
/* see John Cresswell document for details : */
/* AGATA PSA and Tracking Algorithm Integration*/
void process_config (char *directory_path, unsigned int *error_code);
cbuffer *process_register (unsigned int *error_code);
/* the call of this routine is different from the one in the document */
/* because document discribe filter interface and here we consume data */
/* ask X. Grave grave@ipno.in2p3.fr for more details */
void process_block (cbuffer *algo_data,
		    void *input_buffer,
		    unsigned int size_of_input_buffer,
		    unsigned int *error_code);
/* optionnal symbols */
void process_initialise (cbuffer *algo_data,
			 unsigned int *error_code);
void process_reset (cbuffer *algo_data,
		    unsigned int *error_code);
void process_start (cbuffer *algo_data,
		    unsigned int *error_code);
void process_stop (cbuffer *algo_data,
		   unsigned int *error_code);
void process_pause (cbuffer *algo_data,
		    unsigned int *error_code);
void process_resume (cbuffer *algo_data,
		     unsigned int *error_code);
void process_unload (cbuffer *algo_data,
		     unsigned int *error_code);
};

/* coding region */

void process_config (char *directory_path, unsigned int *error_code)
{
  my_object.process_config (directory_path, error_code);
}

cbuffer *process_register (unsigned int *error_code)
{
  my_object.set_id (next_id);
  next_id++;
  return (cbuffer *) my_object.process_register (error_code);
}

void process_block (cbuffer *algo_data,
		    void *input_buffer,
		    unsigned int size_of_input_buffer,
		    unsigned int *error_code)
{
  algo_data->process_block (input_buffer, size_of_input_buffer,
			    error_code);
}

void process_initialise (cbuffer *algo_data,
			 unsigned int *error_code)
{
  algo_data->process_initialise (error_code);
}
void process_reset (cbuffer *algo_data,
		    unsigned int *error_code)
{
  algo_data->process_reset (error_code);
}
void process_start (cbuffer *algo_data,
		    unsigned int *error_code)
{
  algo_data->process_start (error_code);
}
void process_stop (cbuffer *algo_data,
		   unsigned int *error_code)
{
  algo_data->process_stop (error_code);
}
void process_pause (cbuffer *algo_data,
		    unsigned int *error_code)
{
  algo_data->process_pause (error_code);
}
void process_resume (cbuffer *algo_data,
		     unsigned int *error_code)
{
  algo_data->process_resume (error_code);
}
void process_unload (cbuffer *algo_data,
		     unsigned int *error_code)
{
  algo_data->process_unload (error_code);
}
