#include <iostream>
#include <stdlib.h>
#include "pbuffer.h"
#include "TTree.h"
#include "TBufferFile.h"
#include "TStorage.h"
#include "TRandom.h"

pbuffer::pbuffer ()
{
  some_algo_dependent_data = 0;
  random = 0;
}

void pbuffer::process_config (char *directory_path,
			       unsigned int *error_code)
{
  cout << "call to process_config" << "\n";
  cout << "directory path =" << directory_path << "\n";

  *error_code = 0;
}

void pbuffer::process_block (void *output_buffer,
			      unsigned int size_of_output_buffer,
			      unsigned int *used_size_of_output_buffer,
			      unsigned int *error_code)
{
  TTree *t1 = new TTree();
  TBufferFile *tbuf = new TBufferFile(TBuffer::kWrite,32000);
  char *source;

  cout << "PROD::process_block : libproduce.cc - start\n";

  t1->Branch("random",&random,"random/D");
  for (Int_t i=0;i<100;i++) {
     random = gRandom->Rndm();
     t1->Fill();
  }

  t1->Streamer(*tbuf);

  source = tbuf->Buffer();
  *used_size_of_output_buffer = tbuf->BufferSize();

  cout << "PROD::buffer copy - start\n";
    memcpy((char *) output_buffer, source, tbuf->BufferSize()); 
  cout << "PROD::buffer copy - done\n";

  cout << "PROD::used_size_of_output_buffer = " << *used_size_of_output_buffer << "\n";

  cout << "PROD::process_block : libproduce.cc - done\n";

  some_algo_dependent_data++;
  *error_code = 0;

  tbuf->Delete();
  t1->Delete();
}
