#include <iostream>
#include "fbuffer.h"

fbuffer::fbuffer ()
{
  Int_t port = 9090;

  MyDB = new GSpectra();
  serv = new GNetServerRoot(MyDB);

  serv->SetPort(port);
  serv->StartGNetServer();
 
  spe = new TH1I ("MySpectra","MySpectra",1000,0,1000);
  MyDB->AddSpectrum(spe,"SpectraFamily");
}

void fbuffer::process_config (char *directory_path,
			       unsigned int *error_code)
{
  cout << "call to process_config" << "\n";
  cout << "directory path =" << directory_path << "\n";
  *error_code = 0;
}

void fbuffer::process_block (void *input_buffer,
			      unsigned int size_of_input_buffer,
			      void *output_buffer,
			      unsigned int size_of_output_buffer,
			      unsigned int *used_size_of_output_buffer,
			      unsigned int *error_code)
{
  TTree *t2 = new TTree();
  TBranch *bpoint;
  TBufferFile *tbuf2 = new TBufferFile(TBuffer::kWrite, 32000);
  Double_t value;

  cout << "FILT::process_block : libfilter.cc - start\n";
  cout << "FILT::size_of_input_buffer = " << size_of_input_buffer << "\n";

  tbuf2->Reset();
  tbuf2->SetWriteMode();
     tbuf2->SetBuffer((char *) input_buffer, size_of_input_buffer);

  tbuf2->SetReadMode();
  t2->Streamer(*tbuf2);

  bpoint = t2->GetBranch("random");
  bpoint->SetAddress(&value);

  Int_t nentries = (Int_t) t2->GetEntries();
  for (Int_t i=0;i<nentries;i++) {

     t2->GetEntry(i);
     bpoint->GetEntry(i);
     spe->Fill(value*1000);
  }

  tbuf2->DetachBuffer();
  tbuf2->Delete();
  t2->Delete();

  cout << "FILT::process_block : libfilter.cc - done\n";

  memcpy((char *) output_buffer, (char *) input_buffer, size_of_input_buffer);
  *used_size_of_output_buffer = size_of_input_buffer;
  *error_code = 0; 
}
