--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Types_Definitions_Tp;
with Buffers;

package body Narval.Actors.Actives.Producers.Tp is

   use Log4ada.Loggers;

   procedure On_Stop (Object : access Tp_Producer_Type) is
   begin
      Producers.On_Stop (Producer_Access (Object));
      Info_Out (Object.Logger'Access,
                "Producer => number of events :" &
                  Object.Number_Of_Event_Produced'Img);
   end On_Stop;

   ---------------------
   -- Buffer_Handling --
   ---------------------
   procedure Buffer_Handling
     (Object : access Tp_Producer_Type) is
      Buffer_Handle : Buffers.Buffer_Handle_Type;
      Output_Address : System.Address;
      use Buffers;
   begin
      select
         Object.Outputs (1).Buffer.Get_Free_Buffer (Buffer_Handle);
         Output_Address := Buffer_Handle.Get_Address;
         declare
            Data : Types_Definitions_Tp.Event_Type;
            for Data'Address use Output_Address;
            use type Interfaces.Unsigned_64;
         begin
            Data.Words (Data.Words'First) := Object.Number_Of_Event_Produced;
            Object.Number_Of_Event_Produced := Object.Number_Of_Event_Produced + 1;
            Buffer_Handle.Set_Used_Bytes (Data'Size / 8);
         end;
         Object.Outputs (1).Buffer.Release_Free_Buffer (Buffer_Handle);
      or
         delay 1.0;
      end select;
   end Buffer_Handling;

end Narval.Actors.Actives.Producers.Tp;
