--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Types_Definitions_Tp;

package body Narval.Actors.Actives.Consumers.Tp is

   ----------------------------
   -- Travail_En_Acquisition --
   ----------------------------

   procedure Buffer_Handling
     (Object : access Tp_Consumer_Type) is
   begin
      declare
         Buffer_Handle : Buffers.Buffer_Handle_Type;
         Size : Buffers.Buffer_Size_Type;
         use type Buffers.Buffer_Size_Type;
	 Input_Address : System.Address;

      begin
         select
            Object.Inputs (1).Buffer.Get_Full_Buffer (Buffer_Handle);
            Size := Buffer_Handle.Get_Used_Bytes;
	    Input_Address := Buffer_Handle.Get_Address;
	    declare
	       Data : Types_Definitions_Tp.Event_Type;
	       for Data'Address use Input_Address;
	    begin
	       Log4ada.Loggers.Info_Out (Object.Logger'Access, "Event first position" & 
					   Data.Words(Data.Words'First)'Img);
	    end;
            Object.Inputs (1).Buffer.Release_Full_Buffer (Buffer_Handle);
         or
            delay 1.0;
            Log4ada.Loggers.Warn_Out (Object.Logger'Access,
                                      "waiting for data");
         end select;
      end;
   end Buffer_Handling;

end Narval.Actors.Actives.Consumers.Tp;
