with Types_Definitions_Tp;
with Buffers;
with Interfaces;

package body Narval.Actors.Actives.Filters_Tp is

   procedure Buffer_Handling
     (Object : access Tp_Filter_Type) is
      Full_Buffer_Handle : Buffers.Buffer_Handle_Type;
      Free_Buffer_Handle : Buffers.Buffer_Handle_Type;
      Output_Address : System.Address;
      Input_Address : System.Address;
      Input_Size : Buffers.Buffer_Size_Type;
      Output_Size : Buffers.Buffer_Size_Type;
      Used_Size_Of_Output_Buffer : Interfaces.Unsigned_32 := 0;
      Input_Buffer : Buffers.Local.Local_Buffer_Type renames
        Object.Inputs (Object.Inputs'First).Buffer;
      Output_Buffer : Buffers.Local.Duplicate.Duplicate_Buffer_Type renames
        Object.Outputs (Object.Outputs'First).Buffer;
      use Buffers;
      use type Interfaces.Unsigned_32;
   begin
      select
         Input_Buffer.Get_Full_Buffer (Full_Buffer_Handle);
         loop
            select
               Output_Buffer.Get_Free_Buffer (Free_Buffer_Handle);
               exit;
            or
               delay 1.0;
               Log4ada.Loggers.Info_Out
                 (Object.Logger'Access,
                  " filter => waiting for free memory");
            end select;
         end loop;
         Input_Size := Full_Buffer_Handle.Get_Used_Bytes;
         Input_Address := Full_Buffer_Handle.Get_Address;
         Output_Size := Free_Buffer_Handle.Get_Available_Bytes;
         Output_Address := Free_Buffer_Handle.Get_Address;
         declare
            Output_Data : Types_Definitions_Tp.Event_Type;
            for Output_Data'Address use Output_Address;
            use type Interfaces.Unsigned_64;
            Input_Data : Types_Definitions_Tp.Event_Type;
            for Input_Data'Address use Input_Address;
         begin
            for I in Output_Data.Words'Range loop
               Output_Data.Words (I) := Input_Data.Words (I) * 2;
            end loop;
            Object.Number_Of_Event_Produced :=
              Object.Number_Of_Event_Produced + 1;
            Free_Buffer_Handle.Set_Used_Bytes (Output_Data'Size / 8);
         end;
         Input_Buffer.Release_Full_Buffer (Full_Buffer_Handle);
         Used_Size_Of_Output_Buffer :=
           Types_Definitions_Tp.Event_Type'Size / 8;
         Free_Buffer_Handle.Set_Used_Bytes
           (Buffers.Buffer_Size_Type (Used_Size_Of_Output_Buffer));
         Output_Buffer.Release_Free_Buffer (Free_Buffer_Handle);
      or
         delay 1.0;
      end select;
   exception
      when E : others =>
         Log4ada.Loggers.Error_Out (Object.Logger'Access,
                                    "exception in buffer handler",
                                    E);
   end Buffer_Handling;

end Narval.Actors.Actives.Filters_Tp;
