using namespace std;


#include "/produits/sec/CODES/CLASS/CLASS_V3.0_02_2014/source/include/CLASSHeaders.hxx"
#include <sstream>
#include <iomanip>
string dtoa(double num)
{
	ostringstream os(ostringstream::out);
	os<<setprecision(3)<<num;
	return os.str();
}

int main(int argc, char** argv)
{

	CLASS gCLASS(-2*365.25*3600*24);		//gCLASS = Parc
	gCLASS.SetStockManagement(true);
	cSecond year = 3600*8766; // 3600*24*365.25;//Year duration in seconds
	gCLASS.SetTimeStep(year/12);
	
	
	cout << "DB Definition... \t" << endl;
	cout << "\t -decay \t" ;
	DataBank<ZAI>* DecayDB = new DataBank<ZAI>(gCLASS.GetLog(), "/produits/sec/CODES/CLASS/CLASS_V3.0_02_2014/DataBase/Decay.idx");		//loi de décroissance radioactive
	gCLASS.SetDecayDataBase(DecayDB);
	cout << "\t...OK!" << endl;
	
	cout << "\t -MOX \t" ;
	DataBank<IsotopicVector>* MOX = new DataBank<IsotopicVector>(gCLASS.GetLog(), "/produits/sec/CODES/CLASS/CLASS_V3.0_02_2014/DataBase/Data_REP_MOX_IRSN/REP_MOX_BU_40.idx");		//base de données MOX Burn Up 40
	cout << "Calculation of Distance Parameters : " << endl;
	//    MOX->SetDistanceType(1);//Use coefficient calculated by CLASS to estimate the distance between an Isotopic Vector and an EvolutionData from the MOX DataBank
	cout << "\t...OK!" << endl;

	cout << "\t -UOx \t" ;
	EvolutionData DB_REP_UOX_3_7 = EvolutionData(gCLASS.GetLog(), "/produits/sec/CODES/CLASS/CLASS_V3.0_02_2014/DataBase/Data_REP_UOX_IRSN/REP_UOX_3_7_U5.dat");		//Base de données UOX //
	EvolutionData DB_REP_UOX_4_0 = EvolutionData(gCLASS.GetLog(), "/produits/sec/CODES/CLASS/CLASS_V3.0_02_2014/DataBase/Data_REP_UOX_IRSN/REP_UOX_4_0_U5.dat");		//Base de données avec différents enrichissement
	EvolutionData DB_REP_UOX_4_2 = EvolutionData(gCLASS.GetLog(), "/produits/sec/CODES/CLASS/CLASS_V3.0_02_2014/DataBase/Data_REP_UOX_IRSN/REP_UOX_4_2_U5.dat");		//
	//EvolutionData DB_REP_UOX = EvolutionData(gCLASS.GetLog(), "/produits/sec/CODES/CLASS/CLASS_V3.0_02_2014/DataBase/Data_REP_UOX_IRSN/REP_UOX_3_1_U5.dat");		
	cout << "\t...OK!" << endl;
	cout << "DB Definition...\t \t \t...Done!" << endl;

	cout << "Storage Definition... \t"<<endl  ;			//Définition des stocks
	Storage *Stock = new Storage(gCLASS.GetLog());
	Stock->SetName("Stock Pu REP MOX");
	Storage *ReUsable = new Storage(gCLASS.GetLog());
	ReUsable->SetName("Dechets");
	cout << "\t...OK!" << endl;
	
	cout <<"Creation d'un stock initial"<< endl;

	double PuQuantiteIsotopique[5] ; 
	PuQuantiteIsotopique[0]= 9.49e27 ;                 // quantité de 238 Pu
	PuQuantiteIsotopique[1]= 1.65e29 ;                // quantité de 239 Pu
	PuQuantiteIsotopique[2]= 1.20e29 ;                // quantité de 240 			
	PuQuantiteIsotopique[3]= 4.68e28 ;                // quantité de 241 Pu
	PuQuantiteIsotopique[4]= 3.50e28 ;                // quantité de 242 Pu


	IsotopicVector IVStock;
	int IsotopePu = 238 ;
	for(int i=0;i<6;i++)         
	{
	IVStock += ZAI(94,IsotopePu,0) * PuQuantiteIsotopique[i];
	IsotopePu = IsotopePu+1;
	}




	cout << "Pool Definition... \t" <<endl ;		//Définition des piscines
	Pool *Cooling_UOX = new Pool(gCLASS.GetLog(),Stock, gCLASS.GetAbsoluteTime(), (double)year*5 );
	Cooling_UOX->SetName("Cooling Pool for UOX");
	Pool *Cooling_MOX = new Pool(gCLASS.GetLog(),ReUsable, gCLASS.GetAbsoluteTime(), (double)year*5 );
	Cooling_MOX->SetName("Cooling Pool for MOX");
	cout << "\t...OK!" << endl;

	cout << "FabricationPlant Definition... \t" <<endl ;		//Usine de fabrication MOX
	FabricationPlant *FP_MOX = new FabricationPlant(gCLASS.GetLog(),Stock, ReUsable);
	FP_MOX->SetName("Fabrication Plant for MOX");
	cout << "\t...OK!" << endl;


	double UOX_Cycle = year*4;
	double MOX_Cycle = year*4;
	
	cout << "Reactor Definition... \t"<<endl ;				// Définition des réacteurs
	
	Reactor *Belleville_1;
	Reactor *Belleville_2;

	Reactor *Blayais_1_MOX;
	Reactor *Blayais_1_UOX;
	Reactor *Blayais_2_MOX;
	Reactor *Blayais_2_UOX;
	Reactor *Blayais_3;
	Reactor *Blayais_4;

	Reactor *Bugey_2;
	Reactor *Bugey_3;
	Reactor *Bugey_4;
	Reactor *Bugey_5;

	Reactor *Cattenom_1;
	Reactor *Cattenom_2;
	Reactor *Cattenom_3;
	Reactor *Cattenom_4;

	Reactor *Chinon_1_MOX;
	Reactor *Chinon_1_UOX;
	Reactor *Chinon_2_MOX;
	Reactor *Chinon_2_UOX;
	Reactor *Chinon_3_MOX;
	Reactor *Chinon_3_UOX;
	Reactor *Chinon_4_MOX;
	Reactor *Chinon_4_UOX;

	Reactor *Chooz_1;
	Reactor *Chooz_2;

	Reactor *Civaux_1;
	Reactor *Civaux_2;

	Reactor *Cruas_1;
	Reactor *Cruas_2;
	Reactor *Cruas_3;
	Reactor *Cruas_4;

	Reactor *Dampierre_1_MOX;
	Reactor *Dampierre_1_UOX;
	Reactor *Dampierre_2_MOX;
	Reactor *Dampierre_2_UOX;
	Reactor *Dampierre_3_MOX;
	Reactor *Dampierre_3_UOX;
	Reactor *Dampierre_4_MOX;
	Reactor *Dampierre_4_UOX;

	Reactor *Fessenheim_1;
	Reactor *Fessenheim_2;

	Reactor *Flamanville_1;
	Reactor *Flamanville_2;

	Reactor *Golfech_1;
	Reactor *Golfech_2;

	Reactor *Gravelines_1;
	Reactor *Gravelines_2_MOX;
	Reactor *Gravelines_2_UOX;
	Reactor *Gravelines_3_MOX;
	Reactor *Gravelines_3_UOX;
	Reactor *Gravelines_4_MOX;
	Reactor *Gravelines_4_UOX;
	Reactor *Gravelines_5_MOX;
	Reactor *Gravelines_5_UOX;
	Reactor *Gravelines_6;

	Reactor *Nogent_1;
	Reactor *Nogent_2;

	Reactor *Paluel_1;
	Reactor *Paluel_2;
	Reactor *Paluel_3;
	Reactor *Paluel_4;

	Reactor *Penly_1;
	Reactor *Penly_2;

	Reactor *StAlban_1;
	Reactor *StAlban_2;

	Reactor *StLaurent_1_MOX;
	Reactor *StLaurent_1_UOX;
	Reactor *StLaurent_2_MOX;
	Reactor *StLaurent_2_UOX;

	Reactor *Tricastin_1_MOX;
	Reactor *Tricastin_1_UOX;
	Reactor *Tricastin_2_MOX;
	Reactor *Tricastin_2_UOX;
	Reactor *Tricastin_3_MOX;
	Reactor *Tricastin_3_UOX;
	Reactor *Tricastin_4_MOX;
	Reactor *Tricastin_4_UOX;





	

	Belleville_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*13, 3.93e9,108.09,43,0.75) ;			
	Belleville_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*14, 3.93e9,108.09,43,0.75) ;

	Blayais_1_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*6, 0.819e9,21.612,35,0.75) ;
	Blayais_1_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*6, 1.911e9,50.428,43,0.75) ;
	Blayais_2_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*8, 0.819e9,21.612,35,0.75) ;
	Blayais_2_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*8, 1.911e9,50.428,43,0.75) ;
	Blayais_3 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*8, 2.73e9,71.84,42,0.75) ;
	Blayais_4 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*8, 2.73e9,71.84,42,0.75) ;

	Bugey_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_2, Cooling_UOX,0, double(year)*4, 2.73e9,69.87,42,0.75) ;
	Bugey_3 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_2, Cooling_UOX,0, double(year)*4, 2.73e9,69.87,42,0.75) ;
	Bugey_4 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_2, Cooling_UOX,0, double(year)*4, 2.64e9,67.65,42,0.75) ;
	Bugey_5 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_2, Cooling_UOX,0, double(year)*5, 2.64e9,67.65,42,0.75) ;

	Cattenom_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*12, 3.9e9,107.34,43,0.75) ;
	Cattenom_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*13, 3.9e9,107.34,43,0.75) ;
	Cattenom_3 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*16, 3.9e9,107.34,43,0.75) ;
	Cattenom_4 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*17, 3.9e9,107.34,43,0.75) ;

	Chinon_1_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*9, 0.8145e9,21.504,35,0.75) ;
	Chinon_1_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*9, 1.9005e9,50.176,43,0.75) ;
	Chinon_2_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*9, 0.8145e9,21.504,35,0.75) ;
	Chinon_2_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*9, 1.9005e9,50.176,43,0.75) ;
	Chinon_3_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*12, 0.8145e9,21.504,35,0.75) ;
	Chinon_3_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*12, 1.9005e9,50.176,43,0.75) ;
	Chinon_4_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*13, 0.8145e9,21.504,35,0.75) ;
	Chinon_4_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*13, 1.9005e9,50.176,43,0.75) ;

	Chooz_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*25, 4.5e9,107.56,43,0.75) ;
	Chooz_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*25, 4.5e9,107.56,43,0.75) ;

	Civaux_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*27, 4.485e9,107.24,43,0.75) ;
	Civaux_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*27, 4.485e9,107.24,43,0.75) ;

	Cruas_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*9, 2.745e9,72.32,42,0.75) ;
	Cruas_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*10, 2.745e9,72.32,42,0.75) ;
	Cruas_3 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*9, 2.745e9,72.32,42,0.75) ;
	Cruas_4 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*10, 2.745e9,72.32,42,0.75) ;

	Dampierre_1_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*5, 0.801e9,21.144,35,0.75) ;
	Dampierre_1_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*5, 1.869e9,49.336,43,0.75) ;
	Dampierre_2_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*5, 0.801e9,21.144,35,0.75) ;
	Dampierre_2_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*6, 1.869e9,49.336,43,0.75) ;
	Dampierre_3_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*5, 0.801e9,21.144,35,0.75) ;
	Dampierre_3_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*6, 1.869e9,49.336,43,0.75) ;
	Dampierre_4_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*5, 0.801e9,21.144,35,0.75) ;
	Dampierre_4_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*6, 1.869e9,49.336,43,0.75) ;

	Fessenheim_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_2, Cooling_UOX,0, double(year)*3, 2.64e9,67.65,42,0.75) ;
	Fessenheim_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_2, Cooling_UOX,0, double(year)*3, 2.64e9,67.65,42,0.75) ;

	Flamanville_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*11, 3.99e9,109.71,43,0.75) ;
	Flamanville_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*12, 3.99e9,109.71,43,0.75) ;

	Golfech_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*16, 3.93e9,108.09,43,0.75) ;
	Golfech_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*19, 3.93e9,108.09,43,0.75) ;

	Gravelines_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*5, 2.73e9,71.84,42,0.75) ;
	Gravelines_2_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*5, 0.819e9,21.612,35,0.75) ;
	Gravelines_2_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*5, 1.911e9,50.428,42,0.75) ;
	Gravelines_3_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*6, 0.819e9,21.612,35,0.75) ;
	Gravelines_3_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*6, 1.911e9,50.428,42,0.75) ;
	Gravelines_4_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*6, 0.819e9,21.612,35,0.75) ;
	Gravelines_4_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*6, 1.911e9,50.428,42,0.75) ;
	Gravelines_5_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*10, 0.819e9,21.612,35,0.75) ;
	Gravelines_5_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*10, 1.911e9,50.428,42,0.75) ;
	Gravelines_6 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*10, 2.73e9,71.84,42,0.75) ;

	Nogent_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*13, 3.93e9,108.09,43,0.75) ;
	Nogent_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*14, 3.93e9,108.09,43,0.75) ;

	Paluel_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*10, 3.99e9,109.71,43,0.75) ;
	Paluel_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*10, 3.99e9,109.71,43,0.75) ;
	Paluel_3 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*11, 3.99e9,109.71,43,0.75) ;
	Paluel_4 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*11, 3.99e9,109.71,43,0.75) ;

	Penly_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*15, 3.99e9,109.71,43,0.75) ;
	Penly_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*17, 3.99e9,109.71,43,0.75) ;

	StAlban_1 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*11, 4.005e9,110.22,43,0.75) ;
	StAlban_2 = new Reactor(gCLASS.GetLog(),DB_REP_UOX_4_0, Cooling_UOX,0, double(year)*12, 4.005e9,110.22,43,0.75) ;

	StLaurent_1_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*8, 0.8235e9,21.756,35,0.75) ;
	StLaurent_1_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*8, 1.9215e9,50.764,43,0.75) ;
	StLaurent_2_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*8, 0.8235e9,21.756,35,0.75);
	StLaurent_2_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*8, 1.9215e9,50.764,43,0.75) ;

	Tricastin_1_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*5, 0.8235e9,21.756,35,0.75) ;
	Tricastin_1_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*5, 1.9215e9,50.764,43,0.75) ;
	Tricastin_2_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*5, 0.8235e9,21.756,35,0.75) ;
	Tricastin_2_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*5, 1.9215e9,50.764,43,0.75) ;
	Tricastin_3_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*6, 0.8235e9,21.756,35,0.75) ;
	Tricastin_3_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*6, 1.9215e9,50.764,43,0.75) ;
	Tricastin_4_MOX = new Reactor(gCLASS.GetLog(),MOX, FP_MOX, Cooling_MOX,0, double(year)*6, 0.8235e9,21.756,35,0.75) ;
	Tricastin_4_UOX = new Reactor(gCLASS.GetLog(),DB_REP_UOX_3_7, Cooling_UOX,0, double(year)*6, 1.9215e9,50.764,43,0.75) ;



	cout << "\t...OK!" << endl;
	cout << endl << endl;

	cout << "Addind Phase : " << endl;
	cout << "\t -FabricationPlant" ;
	gCLASS.AddFabricationPlant(FP_MOX);		//Ajout de tous les éléments à notre parc
	cout << "\t...OK!" << endl;

	cout << "\t -Pool \t\t" ;
	gCLASS.AddPool(Cooling_UOX);
	gCLASS.AddPool(Cooling_MOX);
	cout << "\t...OK!" << endl;

	cout << "\t -Reactor \t\t" ;
		

	gCLASS.AddReactor(Belleville_1);
	gCLASS.AddReactor(Belleville_2);
	gCLASS.AddReactor(Blayais_1_MOX);
	gCLASS.AddReactor(Blayais_1_UOX);
	gCLASS.AddReactor(Blayais_2_MOX);
	gCLASS.AddReactor(Blayais_2_UOX);
	gCLASS.AddReactor(Blayais_3);
	gCLASS.AddReactor(Blayais_4);
	gCLASS.AddReactor(Bugey_2);
	gCLASS.AddReactor(Bugey_3);
	gCLASS.AddReactor(Bugey_4);
	gCLASS.AddReactor(Bugey_5);
	gCLASS.AddReactor(Cattenom_1);
	gCLASS.AddReactor(Cattenom_2);
	gCLASS.AddReactor(Cattenom_3);
	gCLASS.AddReactor(Cattenom_4);
	gCLASS.AddReactor(Chinon_1_MOX);
	gCLASS.AddReactor(Chinon_1_UOX);
	gCLASS.AddReactor(Chinon_2_MOX);
	gCLASS.AddReactor(Chinon_2_UOX);
	gCLASS.AddReactor(Chinon_3_MOX);
	gCLASS.AddReactor(Chinon_3_UOX);
	gCLASS.AddReactor(Chinon_4_MOX);
	gCLASS.AddReactor(Chinon_4_UOX);
	gCLASS.AddReactor(Chooz_1);
	gCLASS.AddReactor(Chooz_2);
	gCLASS.AddReactor(Civaux_1);
	gCLASS.AddReactor(Civaux_2);
	gCLASS.AddReactor(Cruas_1);
	gCLASS.AddReactor(Cruas_2);
	gCLASS.AddReactor(Cruas_3);
	gCLASS.AddReactor(Cruas_4);
	gCLASS.AddReactor(Dampierre_1_MOX);
	gCLASS.AddReactor(Dampierre_1_UOX);
	gCLASS.AddReactor(Dampierre_2_MOX);
	gCLASS.AddReactor(Dampierre_2_UOX);
	gCLASS.AddReactor(Dampierre_3_MOX);
	gCLASS.AddReactor(Dampierre_3_UOX);
	gCLASS.AddReactor(Dampierre_4_MOX);
	gCLASS.AddReactor(Dampierre_4_UOX);
	gCLASS.AddReactor(Fessenheim_1);
	gCLASS.AddReactor(Fessenheim_2);
	gCLASS.AddReactor(Flamanville_1);
	gCLASS.AddReactor(Flamanville_2);
	gCLASS.AddReactor(Golfech_1);
	gCLASS.AddReactor(Golfech_2);
	gCLASS.AddReactor(Gravelines_1);
	gCLASS.AddReactor(Gravelines_2_MOX);
	gCLASS.AddReactor(Gravelines_2_UOX);
	gCLASS.AddReactor(Gravelines_3_MOX);
	gCLASS.AddReactor(Gravelines_3_UOX);
	gCLASS.AddReactor(Gravelines_4_MOX);
	gCLASS.AddReactor(Gravelines_4_UOX);
	gCLASS.AddReactor(Gravelines_5_MOX);
	gCLASS.AddReactor(Gravelines_5_UOX);
	gCLASS.AddReactor(Gravelines_6);
	gCLASS.AddReactor(Nogent_1);
	gCLASS.AddReactor(Nogent_2);
	gCLASS.AddReactor(Paluel_1);
	gCLASS.AddReactor(Paluel_2);
	gCLASS.AddReactor(Paluel_3);
	gCLASS.AddReactor(Paluel_4);
	gCLASS.AddReactor(Penly_1);
	gCLASS.AddReactor(Penly_2);
	gCLASS.AddReactor(StAlban_1);
	gCLASS.AddReactor(StAlban_2);
	gCLASS.AddReactor(StLaurent_1_MOX);
	gCLASS.AddReactor(StLaurent_1_UOX);
	gCLASS.AddReactor(StLaurent_2_MOX);
	gCLASS.AddReactor(StLaurent_2_UOX);
	gCLASS.AddReactor(Tricastin_1_MOX);
	gCLASS.AddReactor(Tricastin_1_UOX);
	gCLASS.AddReactor(Tricastin_2_MOX);
	gCLASS.AddReactor(Tricastin_2_UOX);
	gCLASS.AddReactor(Tricastin_3_MOX);
	gCLASS.AddReactor(Tricastin_3_UOX);
	gCLASS.AddReactor(Tricastin_4_MOX);
	gCLASS.AddReactor(Tricastin_4_UOX);

	
	cout << "...OK!" << endl;

	cout << "\t -Storage \t\t" ;
	gCLASS.AddStorage(Stock);
	Stock->AddToStock(IVStock);
	gCLASS.AddStorage(ReUsable);

	cout << "...OK!" << endl;

	cout << "Addind Phase...\t \t \t...Done!" << endl;
	cout << endl << endl;
	


	cout << "Beginning the Evolution" << endl;
	gCLASS.Evolution((double)year*50);

}
