/************************************************************/
//              DESCRIPTION
// 
// 
// The brasilian fleat and the candu
// 
// 
//   _______     ________________
//  |       |   |		 |
//  |Storage|==>|FabricationPlant|==>StorageCANDU
//  | UOX   |   |________________|
//  |_______|   		
//  	
//		
//@author BaL
/***********************************************************/
#include "CLASSHeaders.hxx"
#include <sstream>
#include <iomanip>
#include <math.h>
#include <string>
#include "XS/XSM_MLP.hxx"			//Load the include for Neural network cross section predictor
#include "Irradiation/IM_RK4.hxx"		//Load the include for Runge Kutta 4 resolution
#include "Equivalence/EQM_PWR_MLP_MOX.hxx"	//Load the include for Neural Network Equivalence Model (PWRMOX)
#include "Equivalence/EQM_CANDU2.hxx"	//Load the include for Equivalence Model for CANDU 
#include "XS/XSM_CLOSEST.hxx"			//Load the include for CLOSEST cross section
using namespace std;

int main(int argc, char** argv)
{
	//seconds in one year
	cSecond year = 3600*24.*365.25; 
	/******LOG MANAGEMENT**********************************/
	//Definition of the Log file : CLASS messages output 
	int Std_output_level 	= 0; // Only error are shown in terminal
	int File_output_level 	= 2; // Error + Warning + Info are shown in the file CLASS_OUTPUT.log
	CLASSLogger *Logger 	= new CLASSLogger("CLASS_OUTPUT.log",Std_output_level,File_output_level);

	/******SCENARIO**********************************/
	// The scenario start at year 1977
	cSecond StartingTime = year*2015;
	Scenario *gCLASS=new Scenario(StartingTime,Logger);
	gCLASS->SetStockManagement(true);					//If false all the IsotopicVector in stocks are mixed together.
	gCLASS->SetTimeStep(year/26);	 					//the scenario calculation is updated every 3 months
	cSecond EndOfScenarioTime=2040*year;				//Scenario ends in year 2040
	gCLASS->SetOutputFileName("ExampleParc_CANDU_SYM.root");	//Set the name of the output file


		

	/******DATA BASES**********************************/
	//Geting CLASS to path
	string CLASS_PATH = getenv("CLASS_PATH");
	if (CLASS_PATH=="")
   	{
		cout<<" Please setenv CLASS_PATH to your CLASS installation folder in your .bashs or .tcshrc"<<endl;
   	 	exit(0);
   	}
   	string PATH_TO_DATA = CLASS_PATH + "/DATA_BASES/";

	/*===Decay data base===*/
	//The decay data base is taken from the file Decay.idx
	DecayDataBank* DecayDB = new DecayDataBank(gCLASS->GetLog(), PATH_TO_DATA + "DECAY/ALL/Decay.idx"); //you may have to open this file and do the proper changes according your path
	gCLASS->SetDecayDataBase(DecayDB);//This decay data base will be used for all the decay calculations in this Scenario

	/*===Reactor data base===*/

		// Reprocessed fuel PWR MOX
//	XSM_MLP* XSMOX = new XSM_MLP(gCLASS->GetLog(), PATH_TO_DATA + "PWR/MOX/XSModel/30Wg_FullMOX");//Defining the XS Predictor
	XSM_CLOSEST* XSMOX = new XSM_CLOSEST(gCLASS->GetLog(), PATH_TO_DATA + "CANDU_Urep/CANDU_Urep.idx");//Defining the XS Predictor
	IM_RK4 *IMRK4 = new IM_RK4(gCLASS->GetLog());	//Bateman's equation solver method (RungeKutta4)
//	EQM_PWR_MLP_MOX* EQMMLPPWRMOX = new EQM_PWR_MLP_MOX(gCLASS->GetLog(),PATH_TO_DATA + "PWR/MOX/EQModel/MLP/EQM_MLP_PWR_MOX_3batch.xml");//Defining the EquivalenceModel
	EQM_CANDU2* EQMMLPPWRMOX = new EQM_CANDU2(gCLASS->GetLog(),PATH_TO_DATA + "PWR/MOX/EQModel/MLP/EQM_MLP_PWR_MOX_3batch.xml");//Defining the EquivalenceModel
	PhysicsModels* PHYMOD = new PhysicsModels(XSMOX, EQMMLPPWRMOX, IMRK4); 							//The PhysicsModels containing the 3 object previously defined

		//Fixed fuel : PWR UOX

	//The file GEMMES.dat correspond to a fuel evolution of a UOX PWR (see manual for details) I chose this one because enrichment is 4%
	EvolutionData *GEMMES = new EvolutionData(gCLASS->GetLog(), PATH_TO_DATA + "PWR/UOX/FixedFuel/GEMMES.dat");

	/******FACILITIES*********************************/
	/*=== Stock===*/
				//Adding the stock to the Scenario
	//Storage for MOX
	Storage *StockMOX = new Storage(gCLASS->GetLog());	// Definition of the stock
	StockMOX->SetName("StockMOX"); 				// Its name
	gCLASS->Add(StockMOX);					//Adding the stock to the Scenario

  	//Storage for infinite DepU 
  	Storage *Stock = new Storage(gCLASS->GetLog());    //Definition of the stock
  	Stock->SetName("Stock");   //Its name
  	gCLASS->Add(Stock);	//Adding the stock to the Scenario

  	IsotopicVector InfiniteU;
  	InfiniteU.Add(92,238,0,3e31);
  	InfiniteU.Add(92,235,0,3e31);
	InfiniteU.Add(92,234,0,3e31);
	//nfiniteU.Add(92,233,0,3e31);
	//InfiniteU.Add(92,232,0,3e31);
	//InfiniteU.Add(92,231,0,3e31);
	//InfiniteU.Add(92,230,0,3e31);
	InfiniteU.Add(92,236,0,3e31);
	//InfiniteU.Add(92,237,0,3e31);
	//InfiniteU.Add(92,240,0,3e31);

  	Stock->AddToStock(InfiniteU);

	/*===Pool===*/

	//Pool for UOX
/*	Pool *Cooling_UOX1 = new Pool(gCLASS->GetLog(),Stock, 3*year); //After 3 years of cooling, the pool sends its content to "StockUOX"
	Cooling_UOX1->SetName("Pool_UOX1");
	gCLASS->Add(Cooling_UOX1);

	//Pool for UOX
	Pool *Cooling_UOX2 = new Pool(gCLASS->GetLog(),Stock, 3*year); //After 3 years of cooling, the pool sends its content to "StockUOX"
	Cooling_UOX2->SetName("Pool_UOX2");
	gCLASS->Add(Cooling_UOX2);

	//Pool for UOX
	Pool *Cooling_UOX3 = new Pool(gCLASS->GetLog(),Stock, 3*year); //After 3 years of cooling, the pool sends its content to "StockUOX"
	Cooling_UOX3->SetName("Pool_UOX3");
	gCLASS->Add(Cooling_UOX3);*/

	//Pool for MOX
	Pool *Cooling_MOX = new Pool(gCLASS->GetLog(),StockMOX, 5*year); //After 5 years of cooling, the pool sends its content to "StockMOX"
	Cooling_MOX->SetName("Pool_MOX");
	gCLASS->Add(Cooling_MOX);

	/*===A FabricationPlant===*/
	FabricationPlant *FP_MOX = new FabricationPlant(gCLASS->GetLog(), 1.0*year); //Declare a FabricationPlant. After the build of the fuel, it decays during 3years before to be loaded in Reactor
	FP_MOX->SetFiFo(false); //The latest isotopicVector to enter in "Stock" will be used to build the fuel (Opposite of First In First Out)
	FP_MOX->SetName("Fab_MOX");
	FP_MOX->AddFissileStorage(Stock);	//Tell the FP to look in StockUOX for fissionable material 
	//FP_MOX->AddFertileStorage(StockUOX);//Tell the FP to look in Stock2 for fertile material 
	//If fertile stock is not defined (like here), CLASS get fertile from nature (OUTCOMING vector)
	//FP_MOX->SetReUsableStorage(wastestock);//By default the fabricationplant get the list of nuclei defined in the EquivalenceModel (here EQM_MLP_MOX) from stock and send the others nuclei in WASTE. If user want these nuclei to go in another stock  he can use the SetReUsableStorage function
	gCLASS->AddFabricationPlant(FP_MOX);

	


	/*===A Reactor : PWR_UOX===*/

	cSecond Embalse_Time = year*2020;
	cSecond LifeTime;

/*	double  HMMass2 = 103;//heavy metal mass (in tons)
	double	Power_CP02 = 3771e6;//Thermal power (in W)
	double  BurnUp2 = 50; //GWd/tHM I calculated it so that the fuel lasts about 13*3 months in the core. 35.5 ou 50

	cSecond StartingTime2 =  2016*year;
	cSecond LifeTime2     = 40*year;
					
	Reactor* ANGRA2 = new Reactor(gCLASS->GetLog(),	//Log
							   GEMMES,				// Data base
							   Cooling_UOX1,			// Connected Backend facility (here the Storage "Stock" previously declared)
							   StartingTime2,		// Starting time
							   LifeTime2,			// time of reactor life time
							   Power_CP02,			// Power
							   HMMass2,// HM mass
							   BurnUp2,				// BurnUp
							   0.816);			// Load Factor
					

	ANGRA2->SetName("ANGRA2");// name of the reactor (as it will show up in the CLASSGui)
	gCLASS->AddReactor(ANGRA2);//Add this reactor to the scenario
*/					

	/*===A Reactor : PWR_UOX===*/
/*	double  HMMass1 = 49.5;//heavy metal mass (in tons)
	double	Power_CP01 = 1882e6;//Thermal power (in W)
	double  BurnUp1 = 55; //GWd/tHM I calculated it so that the fuel lasts about 13*3 months in the core. 33.4 ou 55

	cSecond StartingTime1 =  2016*year;
	cSecond LifeTime1    = 40*year;
					
	Reactor* ANGRA1 = new Reactor(gCLASS->GetLog(),	//Log
							   GEMMES,				// Data base
							   Cooling_UOX2,			// Connected Backend facility (here the Storage "Stock" previously declared)
							   StartingTime1,		// Starting time
							   LifeTime1,			// time of reactor life time
							   Power_CP01,			// Power
							   HMMass1,// HM mass
							   BurnUp1,				// BurnUp
							   0.834);			// Load Factor
					

	ANGRA1->SetName("ANGRA1");// name of the reactor (as it will show up in the CLASSGui)
	gCLASS->AddReactor(ANGRA1);//Add this reactor to the scenario
					
*/	

	/*===A Reactor : PWR_UOX===*/
	
/*	double  HMMass3 = 103;//heavy metal mass (in tons)
	double	Power_CP03 = 3771e6;//Thermal power (in W)
	double  BurnUp3 = 50; //GWd/tHM I calculated it so that the fuel lasts about 13*3 months in the core. 35.5 ou 50

	cSecond StartingTime3 =  2016*year;
	cSecond LifeTime3     = 40*year;
					
	Reactor* ANGRA3 = new Reactor(gCLASS->GetLog(),	//Log
							   GEMMES,				// Data base
							   Cooling_UOX3,			// Connected Backend facility (here the Storage "Stock" previously declared)
							   StartingTime3,		// Starting time
							   LifeTime3,			// time of reactor life time
							   Power_CP03,			// Power
							   HMMass3,// HM mass
							   BurnUp3,				// BurnUp
							   0.816);			// Load Factor
					

	ANGRA3->SetName("ANGRA3");// name of the reactor (as it will show up in the CLASSGui)
	gCLASS->AddReactor(ANGRA3);//Add this reactor to the scenario
*/

	//the CANDU
	StartingTime =  Embalse_Time;
	LifeTime     =  EndOfScenarioTime - StartingTime;
	double  HMMass_CANDU = 68.62;//heavy metal mass (in tons)
	double	Power_CANDU = 2041e6;//Thermal power (in W)2.551GW
	double  BurnUp_CANDU = 15.9; //33 GWd/tHM


				Reactor* Embalse = new Reactor(gCLASS->GetLog(),// Log
							 			   PHYMOD,			// The models used to build the fuel & to calculate its evolution
							 			   FP_MOX,			// The FabricationPlant
										   Cooling_MOX,			// Connected Backend
										   StartingTime,		// Starting time
										   LifeTime,			// time of reactor l
										   Power_CANDU,			// Power
										   HMMass_CANDU,		// HM mass
										   BurnUp_CANDU,			// BurnUp
										   1.0);			// Load Factor

				Embalse->SetName("Embalse");// name of the reactor (as it will l
				gCLASS->AddReactor(Embalse);//Add this reactor to the scenario



	gCLASS->Evolution((double)EndOfScenarioTime);//Perform the calculation from year 1977(defined in Scenario declaration) to year 2018

	delete gCLASS;

}


//==========================================================================================
// Compilation
//==========================================================================================
/*
 
 \rm CLASS* ; g++ -o CLASS_Exec ExampleParc_LIN_CANDU_SYM.cxx    -I $CLASS_include -L $CLASS_lib -lCLASSpkg `root-config --cflags` `root-config --libs` -fopenmp -lgomp -Wunused-result
 
 
 */
