--  Thu Feb 21 11:35:31 CET 2013 : Stubs Generator 0.1.0. Generate for ENX 2.5.
--  You just have to fill the stub.

with Common; use Common;
with Common.Exceptions;
with Interfaces;
--  with Interfaces.C;
with Ada.Strings.Unbounded;
--  with Ada.Characters.Handling;

with Line_To_XML;
--  with PDM;
--  with Datas;
with Motor_Library;

package body Axmo_Mccl_3axis is

   ----------
   -- Init --
   ----------
   procedure Init (Obj : access T_Axmo_Mccl_3axis) is
   begin
      null;
   end Init;

   -----------
   -- Close --
   -----------
   procedure Close (Obj : access T_Axmo_Mccl_3axis) is
   begin
      null;
   end Close;

   ------------------------------------------------------------------------
   -- Write_32 : This function is called when ENX receives a MM command. --
   ------------------------------------------------------------------------
   procedure Write_32
     (Obj     : access T_Axmo_Mccl_3axis;
      Command : T_Command_Access)
   is
   begin
      raise Common.Exceptions.NOT_AVAILABLE;
   end Write_32;

   -------------------------------------------------------------------------
   -- Write_16 : This function is called when ENX receives a MMH command. --
   -------------------------------------------------------------------------
   procedure Write_16
     (Obj     : access T_Axmo_Mccl_3axis;
      Command : T_Command_Access)
   is
   begin
      raise Common.Exceptions.NOT_AVAILABLE;
   end Write_16;

   ------------------------------------------------------------------------
   -- Write_8 : This function is called when ENX receives a MMB command. --
   ------------------------------------------------------------------------
   procedure Write_8
     (Obj     : access T_Axmo_Mccl_3axis;
      Command : T_Command_Access)
   is
   begin
      raise Common.Exceptions.NOT_AVAILABLE;
   end Write_8;

   -----------------------------------------------------------------------
   -- Read_32 : This function is called when ENX receives a MD command. --
   -----------------------------------------------------------------------
   function Read_32
     (Obj     : access T_Axmo_Mccl_3axis;
      Command : T_Command_Access)
      return    T_Result_Access
   is
   begin
      raise Common.Exceptions.NOT_AVAILABLE;
      return new T_Result (NO_RESULT);
   end Read_32;

   ------------------------------------------------------------------------
   -- Read_16 : This function is called when ENX receives a MDH command. --
   ------------------------------------------------------------------------
   function Read_16
     (Obj     : access T_Axmo_Mccl_3axis;
      Command : T_Command_Access)
      return    T_Result_Access
   is
   begin
      raise Common.Exceptions.NOT_AVAILABLE;
      return new T_Result (NO_RESULT);
   end Read_16;

   -----------------------------------------------------------------------
   -- Read_8 : This function is called when ENX receives a MDB command. --
   -----------------------------------------------------------------------
   function Read_8
     (Obj     : access T_Axmo_Mccl_3axis;
      Command : T_Command_Access)
      return    T_Result_Access
   is
   begin
      raise Common.Exceptions.NOT_AVAILABLE;
      return new T_Result (NO_RESULT);
   end Read_8;

   ----------------------------------------------------------------------------
   -- Special : This function is called when ENX receives a SPECIAL command. --
   ----------------------------------------------------------------------------
   function Special
     (Obj     : access T_Axmo_Mccl_3axis;
      Command : T_Command_Access)
      return    T_Result_Access
   is
      use Line_To_XML;
      --  Command_And_Arguments contient une matrice avec
      --  la "commande" & les "arguments" sans les blancs
      --  definition de
      --  "commande" : premiere chaine passee
      --  "arguments": chacune des chain es suivantes; il peut y en avoir plusieurs
      Command_And_Arguments : constant Line_To_XML.T_Param :=
         Line_To_XML.Cut_String
            (Ada.Strings.Unbounded.To_String (Command.Command),
            Ada.Strings.Unbounded.To_String (Command.Command)'Length);

      Res : constant T_Result_Access := new T_Result (SPECIAL);

   begin

      --  verification si il y a bien une fonction passee
      if Command_And_Arguments.Size = 0 then
         Res.Text := Ada.Strings.Unbounded.To_Unbounded_String
                              ("function not passed");
      else
         declare
            --  "commande"
            Command_To_Use : T_Special_Command;
         begin
            --  Si la commande ne fait pas partie de la liste
            --  on traite l erreur
            begin
               Command_To_Use := T_Special_Command'Value
                  (Ada.Strings.Unbounded.To_String
                     (Command_And_Arguments.List (0)));
            exception
               when Constraint_Error =>  --  others
                  Command_To_Use := NO_FUNCTION_OR_PROCEDURE;
            end;

            --  traite les differentes fonctions & procedures  --
            -----------------------------------------------------
            case Command_To_Use is

            --  procedure de test  --
            -------------------------
            when TEST =>
               declare
                  Local_Value : Interfaces.IEEE_Float_32;
               begin
                  Local_Value := 22.0;
                  Res.Text :=
                     Ada.Strings.Unbounded.To_Unbounded_String
                        (Interfaces.IEEE_Float_32'Image (Local_Value));
               end;

            --  procedure home  --
            ----------------------
            when HOME =>
               --  verification du nombre de parametres
               if Command_And_Arguments.Size /= 2 then
                  Res.Text := Ada.Strings.Unbounded.To_Unbounded_String
                              ("number of parameters is incorrect");
               else
                  declare
                     --  Axis_1, Axis_2, Axis_3
                     Argument_1 : constant Motor_Library.Motor_Axis_Enum :=
                        Motor_Library.Motor_Axis_Enum'Value
                           (Ada.Strings.Unbounded.To_String
                              (Command_And_Arguments.List (1)));

                  begin
                     Motor_Library.Home
                        (Axis =>  Argument_1);
                     Res.Text := Ada.Strings.Unbounded.To_Unbounded_String ("ok");
                  end;
               end if;

            --  procedure tell position  --
            -------------------------------
            when TELL_POSITION =>
               --  verification du nombre de parametres
               if Command_And_Arguments.Size /= 2 then
                  Res.Text := Ada.Strings.Unbounded.To_Unbounded_String
                              ("number of parameters is incorrect");
               else
                  declare
                     --  Axis_1, Axis_2, Axis_3
                     Argument_1 : constant Motor_Library.Motor_Axis_Enum :=
                        Motor_Library.Motor_Axis_Enum'Value
                           (Ada.Strings.Unbounded.To_String
                              (Command_And_Arguments.List (1)));

                     --  Position_lue
                     Position_Value : Motor_Library.Abs_Position_Int;

                  begin
                     --  lit la position
                     Motor_Library.Tell_Position
                        (Axis =>  Argument_1,
                        Position => Position_Value);
                     --  renvoie la position
                     Res.Text :=
                        Ada.Strings.Unbounded.To_Unbounded_String
                           (Motor_Library.Abs_Position_Int'Image (Position_Value));
                  end;
               end if;

            --  procedure move  --
            ----------------------
            when MOVE =>
               --  verification du nombre de parametres
               if Command_And_Arguments.Size /= 4 then
                  Res.Text := Ada.Strings.Unbounded.To_Unbounded_String
                              ("number of parameters is incorrect");
               else
                  declare
                     --  Axis_1, Axis_2, Axis_3
                     Argument_1 : constant Motor_Library.Motor_Axis_Enum :=
                        Motor_Library.Motor_Axis_Enum'Value
                           (Ada.Strings.Unbounded.To_String
                              (Command_And_Arguments.List (1)));

                     --  Absolute, Relative
                     Argument_2 : constant Motor_Library.Movement_Enum :=
                        Motor_Library.Movement_Enum'Value
                           (Ada.Strings.Unbounded.To_String
                              (Command_And_Arguments.List (2)));

                     --  Position_In
                     Argument_3 : constant Motor_Library.Abs_Position_Int :=
                        Motor_Library.Abs_Position_Int'Value
                           (Ada.Strings.Unbounded.To_String
                              (Command_And_Arguments.List (3)));

                     --  Position_lue
                     Position_Value : Motor_Library.Abs_Position_Int;

                  begin
                     --  deplacement
                     Motor_Library.Move
                        (Axis =>  Argument_1,
                        Movement =>  Argument_2,
                        Position_In =>  Argument_3,
                        Position_Out => Position_Value);
                     --  renvoie la position
                     Res.Text :=
                        Ada.Strings.Unbounded.To_Unbounded_String
                           (Motor_Library.Abs_Position_Int'Image (Position_Value));
                  end;
               end if;


            --  When others  --
            -------------------
            when others =>  --  NO_FUNCTION_OR_PROCEDURE
               Res.Text := Ada.Strings.Unbounded.To_Unbounded_String
                              ("Found no special function");
            end case;

         end;
      end if;

      return Res;
   end Special;

   ---------------------------------------------------------------------
   -- Special_Help : This function is called when ENX receives a HELP --
   --                command on special command.                      --
   ---------------------------------------------------------------------
   function Special_Help
     (Obj     : access T_Axmo_Mccl_3axis;
      Command : T_Command_Access)
      return    T_Result_Access
   is
      Res : constant T_Result_Access := new T_Result (HELP);
   begin
      Res.Text :=  Ada.Strings.Unbounded.To_Unbounded_String
        (ASCII.LF & ASCII.LF &
         "Function Name    : Parameters                        : return value " & ASCII.LF &
         "HOME             : Axis                            " & ASCII.LF &
         "TELL_POSITION    : Axis                              : Position" & ASCII.LF &
         "MOVE             : Axis, Rel-Abs, Position           : Position" & ASCII.LF & ASCII.LF &
         "Note : Axis is Axis_1, Axis_2 or Axis_3" & ASCII.LF &
         "     : Rel-Abs is Absolute or Relative" & ASCII.LF &

        ASCII.LF);

      return Res;
   end Special_Help;
   ---------------------------------------------------------------------
   -- Dump : This function is called when ENX receives a DUMP command --
   ---------------------------------------------------------------------
   function Dump
     (Obj     : access T_Axmo_Mccl_3axis;
      Command : T_Command_Access)
      return    T_Result_Access
   is
   begin
      raise Common.Exceptions.DUMP_NOT_AVAILABLE;
      return new T_Result (NO_RESULT);
   end Dump;

   ----------------------------------------------------------------------
   -- Load : This procedure is called when ENX receives a LOAD command --
   ----------------------------------------------------------------------
   procedure Load
     (Obj     : access T_Axmo_Mccl_3axis;
      Command : T_Command_Access)
   is
   begin
      raise Common.Exceptions.LOAD_NOT_AVAILABLE;
   end Load;
end Axmo_Mccl_3axis;
